// QuickSort.java
//
// Solution by:
//
//		Jason W. Pegg
//		Senior Network Engineer
//		Aurora Development Group
//
// For:
//
//		The ACM Pacific NW Region Programming Contest
//		November 15, 1997
//
// Problem E - The Boggle Game
//

import java.util.Vector;


public class QuickSort 
{
	private Vector v;				// vector to sort

	public QuickSort()
	{
		// required by the compiler
		;
	}

	public QuickSort(Vector v)
	{
		this.v = v;
	}


	public void StartSort()
	{
		QuickS(0, v.size() - 1);
	}


	public void AssignNew(Vector v)
	{
		this.v = v;
	}


	private void QuickS(int intLow, int intHigh)
	{
		int intMiddle;

		if (intLow < intHigh)
		{
			intMiddle = Split(intLow, intHigh);
			QuickS(intLow, intMiddle - 1);
			QuickS(intMiddle + 1, intHigh);
		}
	}


	private int Split(int intLow, int intHigh)
	{
		int intLeft = intLow;
		int intRight = intHigh;
		String strPivot = (String)v.elementAt(intLow);


		while (intLeft < intRight)
		{
			while (strPivot.compareTo((String)v.elementAt(intRight)) < 0)
				intRight--;

			while ((intLeft < intRight) &&
					(strPivot.compareTo((String)v.elementAt(intLeft)) >= 0))
				intLeft++;

			if (intLeft < intRight)
			{
				String strTemp = new String((String)v.elementAt(intLeft));
				v.setElementAt((String)v.elementAt(intRight), intLeft);
				v.setElementAt(strTemp, intRight);
			}
		}

		v.setElementAt((String)v.elementAt(intRight), intLow);
		v.setElementAt(strPivot, intRight);

		return intRight;
	}
}

